/******************************************************************************

  Copyright (C) 2010 [Hilscher Gesellschaft für Systemautomation mbH]

  This program can be used by everyone according to the netX Open Source
  Software license. The license agreement can be downloaded from
  http://www.industrialNETworX.com

 ******************************************************************************

  Last Modification:
    @version $Id: ProfibusMPI_AP_Functionlist.h 12339 2010-11-19 10:57:43Z AndreasB $

  Description:
    The header has to be included in the configuration source file of firmware.
    Use the content of header file to configure the startup parameter of tasks
    and to define the entry point <code>TaskEnter_ProfibusMPI_AP</code>
    of task.

  Changes:
    Date        Author        Description
  ---------------------------------------------------------------------------
    2010-10-20  NC            File created.

******************************************************************************/
#ifndef __PROFIBUS_MPI_AP_FUNCTIONLIST_H
#define __PROFIBUS_MPI_AP_FUNCTIONLIST_H

#include "TLR_INX_Includes.h"

/******************************************************************************
   The following prototypes are declared to represent
      - the entry point of task
      - the exit point of task to delete only the task resources (exit)
******************************************************************************/
TLR_RESULT TaskExit_ProfibusMPI_AP( TLR_VOID * pvRsc );
TLR_VOID TaskEnter_ProfibusMPI_AP( TLR_VOID * pvInit );

/******************************************************************************
  Version of task startup parameter
    compiler error because of new name of define (e.g. _1 --> _2), check
    startup parameters for changes/extensions!
******************************************************************************/
#define PROFIBUS_MPI_AP_STARTUP_PARAM_VERSION_2 (2)

/******************************************************************************
  Startup Parameter
   The structure represent a set of the startup parameter, which can be defined
    or have to be defined to configure the task.
******************************************************************************/

/* Default peripheral IDs for status Leds */
#define PROFIBUS_MPI_AP_STATUS_LED_GRN_NAME   "FB_STA_GREEN"
#define PROFIBUS_MPI_AP_STATUS_LED_RED_NAME   "FB_STA_RED"

typedef struct PROFIBUS_MPI_AP_STARTUPPARAMETER_Ttag
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  TLR_STR*      pszLedGrn; /* Peripheral ID of green status led */
  TLR_STR*      pszLedRed; /* Peripheral ID of red status led */

}PROFIBUS_MPI_AP_STARTUPPARAMETER_T;

#endif /* __PROFIBUS_MPI_AP_FUNCTIONLIST_H */
